# Version 2.9 - 2.10

Attributes have been added to category overrides. This has led to some changes being required to the category override system.

## Category Override Changes

Every category override that is saved has a hash that represents the category it is overriding and any filter combinations it needs to match with. The hash used to be generated in the `generateOverrideHash()` method of the `EvShop.CategoryOverride` model. This took 3 parameters: the category id, the brand id and a list of option ids. As attributes were being added this has been changed to pass in an array of data to be hashed. The category id, brand id and list of option ids are still passed in but in a formatted array:

```
[
	'categoryId' => '123',
	'brandId' => null,
	'options' => [
		1,
		3,
		5,
		7,
		9
	],
	'attributes' => [
		2,
		4,
		6,
		8
	],
]
```

If the `generateOverrideHash()` method was extended then the extended method declaration needs to be updated to match the new version and any data passed into it put into the formatted array above. Due to data being passed into this method from multiple places and potentially in different structures, a new couple of new methods have been created to process data from certain locations into the correct format to be hashed. The `_getHashSaveData()` method in the `EvShop.CategoryOverride` model and the `_getHashData()` method in the `EvShop.CategoryOverrides` component are available to do this. The model method designed to format data from beforeBeforeSave and the component method to format data from filters.

## Hash changes

Due to the addition of attributes to category overrides, the hash that is generated for each category override has had to be changed to accommodate them and changed to hash custom data more robustly. This does mean that any override hashes that have been generated on previous version might not match up to the new hash generated when loading a category. To make sure that they still match, the hash on each override needs to be regenerated. I a new shell has been added to help speed that process up. Use the following command to regenerate the override hashes.

`app/Console/cake EvShop.Overrides regenerateHashes`

This will use the new logic to generate the hash without changing any of the category override data, therefore syncing them to match any filters used. This shell can also be used if custom data is added to the hash after hashes have been generated. If you need to regenerate hashes over multiple environments, a migration can be used to regenerate them once using the `regenerateHashes()` in the `EvShop.CategoryOverride` model.
